<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('client_id', 'title', 'thumbnail', 'content', 'publish_date', 'category_id');

    public function article_type()
    {
        return $this->hasOne('Category');
    }

    public function hasFav()
    {
        return $this->hasMany('ArticleClient');
    }

}